<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Range Bar Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array(
        array("label"=> "Piano", "y"=> array(28, 4186)),
        array("label"=> "Trumpet", "y"=> array(165, 988)),
        array("label"=> "Violin", "y"=> array(196, 3136)),
        array("label"=> "Acoustic Guitar", "y"=> array(82, 1397)),
        array("label"=> "Concert Flute", "y"=> array(262, 1976)),
        array("label"=> "4 String Bass Guitar", "y"=> array(41, 262)),
        array("label"=> "Electric Guitar", "y"=> array(82, 1397))
    );
?>

<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            title: {
                text: "Fundamental Frequency Ranges of few Instruments"
            },
            axisY:{
                title: "Frequency",
                suffix: " Hz",
                logarithmic: true
            },
            toolTip: {
                shared: true,
                reversed: true
            },
            theme: "dark1",
            data: [
                {
                    type: "rangeBar",
                    indexLabel: "{y[#index]} Hz",
                    toolTipContent: "<b>{label}</b>: {y[0]} Hz to {y[1]} Hz",
                    dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
                }
            ]
        });
        
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>